-- On se place dans le contexte de la base master
USE master;
GO
-- On cre un compte de connexion SQL
CREATE LOGIN CNX_MACHINE WITH PASSWORD = 'Metropolis';
GO
-- On se place dans le contexte de la base DB_MAGIC
USE DB_MAGIC
GO
-- On cre lutilisateur relatif au compte nouvellement cr
CREATE USER USR_MACHINE FROM LOGIN CNX_MACHINE;
GO
-- On cre une table
CREATE TABLE dbo.T_TRACE_MACHINE
(ID            INT IDENTITY PRIMARY KEY,
 DH            DATETIME,
 TRACE         NVARCHAR(256),
 USER_MACHINE  sysname DEFAULT USER);
GO
-- On octroie le privilge INSERT sur la table prfixe par son schma
GRANT INSERT ON dbo.T_TRACE_MACHINE TO USR_MACHINE;
GO
-- Autre manire doctroyer le privilge INSERT sur lobjet
GRANT INSERT ON OBJECT::dbo.T_TRACE_MACHINE TO USR_MACHINE;
GO
-- Autre manire encore dattribuer le privilge sur la table sans son schma
GRANT INSERT ON T_TRACE_MACHINE TO USR_MACHINE;
GO
--> NOTA : dbo doit tre le schma par dfaut